// import Swiper JS
import Swiper, { Navigation, Pagination } from "swiper";
import GLightbox from "glightbox";

// import Swiper styles
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";

document.addEventListener("DOMContentLoaded", () => {
  let swiper = new Swiper(".sliderShow", {
    effect: "fade",
  });

  // carrusel
  let swiperCarruselOffert = new Swiper(".ofertas-carrusel", {
    slidesPerView: 3,
    spaceBetween: 25,
    modules: [Pagination, Navigation],
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
    },
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    breakpoints: {
      300: {
        slidesPerView: 1,
        spaceBetween: 0,
      },
      360: {
        slidesPerView: 1,
        spaceBetween: 12,
      },
      640: {
        slidesPerView: 2,
        spaceBetween: 12,
      },
      768: {
        slidesPerView: 2,
        spaceBetween: 12,
      },
      1024: {
        slidesPerView: 3,
        spaceBetween: 30,
      },
    },
  });

  let menu = new Swiper(".menu-carrusel", {
    slidesPerView: 3,
    spaceBetween: 25,
    modules: [Pagination, Navigation],
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
    },
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    breakpoints: {
      300: {
        slidesPerView: 1,
        spaceBetween: 0,
      },
      360: {
        slidesPerView: 1,
        spaceBetween: 12,
      },
      640: {
        slidesPerView: 2,
        spaceBetween: 12,
      },
      768: {
        slidesPerView: 2,
        spaceBetween: 12,
      },
      1024: {
        slidesPerView: 3,
        spaceBetween: 30,
      },
    },
  });

  let swiperCarruselRes = new Swiper("#restaurantes .restaurante-carrusel", {
    slidesPerView: 3,
    spaceBetween: 25,
    modules: [Pagination, Navigation],
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
    },
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    breakpoints: {
      300: {
        slidesPerView: 1,
        spaceBetween: 0,
      },
      360: {
        slidesPerView: 1,
        spaceBetween: 12,
      },
      640: {
        slidesPerView: 2,
        spaceBetween: 12,
      },
      768: {
        slidesPerView: 2,
        spaceBetween: 12,
      },
      1024: {
        slidesPerView: 3,
        spaceBetween: 30,
      },
    },
  });

  // Scroll smooth
  document.querySelectorAll('a[href^="#"]').forEach((anchor) => {
    anchor.addEventListener("click", function (e) {
      e.preventDefault();

      if (this.getAttribute("href") !== "#")
        document.querySelector(this.getAttribute("href")).scrollIntoView({
          behavior: "smooth",
        });
    });
  });
});

// Obtener menu por categorias
document.addEventListener("click", (e) => {
  if (e.target.classList.contains("menu")) {
    // const $change = document.getElementById("change"); bug
    const id = e.target.getAttribute("data-id");
    const active = document.querySelector(".active");

    document
      .querySelector(`#${active.getAttribute("data-id")}`)
      .classList.add("ohidden");
    document.querySelector(`#${id}`).classList.remove("ohidden");

    document.querySelector(".active").classList.remove("active");
    e.target.classList.add("active");

    // removido por bugs
    // fetch("json.php?id=" + id)
    //   .then((res) => res.json())
    //   .then((json) => {
    //     let fragment = document.createDocumentFragment();

    //     json.forEach((item) => {
    //       const div = document.createElement("div");
    //       div.classList.add("swiper-slide");

    //       const html = `
    //           <a href="#${item.img}" class="glightbox-menu prevent">
    //             <img src="${item.img}" alt="" class="h-80 w-full object-cover">
    //           </a>
    //           <h3 class="mt-4 font-bold text-[#d0291b] text-2xl">${item.name}</h3>
    //           <p>${item.desc}</p>
    //           <div class="precios mt-3">
    //              <span class="font-bold pr-1 text-sm"> ${item.prices}</span>
    //           </div>
    //         `;
    //       div.innerHTML = html;
    //       fragment.appendChild(div);
    //     });
    //     $change.innerHTML = "";

    //     $change.appendChild(fragment);
    //   });
  }

  if (e.target.classList.contains("prevent")) {
    console.log("prevent");
    e.target.preventDefault();
  }
});

const restaurantes = GLightbox({
  selector: ".glightbox-restaurantes",
});

const ofertas = GLightbox({
  selector: ".glightbox-ofertas",
});

const menus = GLightbox({
  selector: ".glightbox-menu",
});
